
/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  30 October 2008
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version TLK_SCLK_ATP_UTIL.c#1:csrc:1
*  \author Liron Dror
*  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ***********************************/
#include "DX_VOS_Stdio.h"
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_File.h"

#if TLK_SCLK_VNVS_SST_ON_SEP
#include "sst.h"
#endif

#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"
#include "TLK_SCLK_TST_UTIL.h"
#include "TLK_SCLK_ATP_Defines.h"
#include "TLK_SCLK_ATP_data.h"
/*****************************************************************************
* Function Name:                                                           
*  TLK_SCLK_TST_CheckErrorReturn        
* 
* Inputs:
*  DxUint32_t  TST_ErrorRet - The return value of the checked function
*  char        TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
*  char        TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* this function returns the appropriate printing for a checked function 
* If the operation had succeeded of failed the appropriate printing and return value.
*
******************************************************************************/
DxError_t TLK_SCLK_TST_CheckErrorReturn(DxError_t TST_ErrorRet, 
                                        char    TST_FuncName[TST_FUNC_STRING_LEN],
                                        char    TST_MasterTestName[TST_FUNC_STRING_LEN])
{
  if ((TST_ErrorRet == DX_SUCCESS))
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"TST_message - "));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"%s",TST_FuncName));
    ATP_LOG_TST_PRINT((MW_ATP_MSG," pass \n"));                                       
    return TST_PASS;
  }
  else
  {
     ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
     ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
     ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - Return code 0x%x \n",TST_ErrorRet));   
    return TST_FAIL;
  }
}

/*****************************************************************************
* Function Name:                                                           
*  TLK_SCLK_TST_GetFormattedTime        
* 
* Inputs:
*  TLK_SCLK_TimeFormat_t         TimeFormat - time format 
*  TLK_SCLK_ServiceClockTime_t   *SysTime_ptr - pointer to system time.
*  DxUint32_t                    offset - the relevant offset of the service clock
*
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* this function returns the system time in the given time format.
*
******************************************************************************/

DxError_t TLK_SCLK_TST_GetFormattedTime(TLK_SCLK_TimeFormat_t                   TimeFormat,
                                        DxUint32_t                              Offset,
                                        TLK_SCLK_ServiceClockTime_t             *SysTime_ptr)       
{

  DxTime_t    TST_TimeInSeconds;
  DxError_t   TST_Error;

  /*Gets the number of seconds passed from 1/1/1970 00:00 */
  TST_Error = MW_TST_Util_GetTime(&TST_TimeInSeconds);

  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"MW_TST_Util_GetTime", "TLK_SCLK_TST_GetFormattedTime");

  if (TST_Error != TST_PASS)
    return TST_FAIL;
 
  if(TST_TimeInSeconds == 0)
    return TST_FAIL;

  if(TimeFormat == TLK_SCLK_SECONDS_SINCE_FORMAT)
  {
    SysTime_ptr->secondsSinceFormat = TST_TimeInSeconds + Offset;
  }
  else
  {
    TST_TimeInSeconds += Offset;

    TST_Error = DX_VOS_SecsToGenTime(TST_TimeInSeconds, 
                                     &(SysTime_ptr->dateTimeFormat));     
    if (TST_Error != DX_SUCCESS)
      return TST_FAIL;

  }

  return TST_PASS;
}

/*****************************************************************************
* Function Name:                                                           
*  TLK_SCLK_TST_InitSST        
* 
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* this function initialize the SST.
*
******************************************************************************/
DxError_t TLK_SCLK_TST_Init(void)
{
 DxError_t TST_Error;

 /*1.	Call TLK_SCLK_WorkspaceSizeGet and get workspace size. */
 TST_Error = TLK_SCLK_WorkspaceSizeGet(&TST_gWorkSpaceSizeInBytes);

 TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"TLK_SCLK_WorkspaceSizeGet", "TLK_SCLK_TST_Init");

 if (TST_Error != TST_PASS)
   return TST_FAIL;

 if(TST_gWorkSpaceSizeInBytes < TLK_SCLK_MIN_WORKSPACE_IN_SIZE_IN_BYTES)
   TST_Error = TST_FAIL;
 else
   TST_Error = TST_PASS;


 TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"Insufficient Workspace Size ", "TLK_SCLK_TST_Init");
 if (TST_Error != TST_PASS)
   return TST_FAIL;


 #if TLK_SCLK_VNVS_SST
 #ifndef DX_NVS_RAM  
   
   TST_Error = DX_VOS_FOpen(&TST_gMainDBFileHandle,TLK_SCLK_TEST_DB_FILENAME ,"w+b");
   TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"TST_gMainDBFileHandle","TLK_SCLK_TST_Init");
   MW_ATP_RETURN_ON_FAILURE(TST_Error);

   TST_Error = DX_VOS_FOpen(&TST_gSecondaryDBFileHandle,TLK_SCLK_TEST_DB_FILENAME_SECOND ,"w+b");
   TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"DX_VOS_FOpen - TST_gSecondaryDBFileHandle","TLK_SCLK_TST_Init");
   MW_ATP_RETURN_ON_FAILURE(TST_Error);
#else
   TST_gMainDBFileHandle        = (DxVosFile)TST_MainSCLK_TLK_DBPool;
   TST_gSecondaryDBFileHandle   = (DxVosFile)TST_SecondarySCLK_TLK_DBPool;
#endif

  TST_Error = SST_Init((DxNvsMemoryId_t)TST_gMainDBFileHandle,
                       (DxNvsMemoryId_t)TST_gSecondaryDBFileHandle,
                       DX_NULL,
                       TST_gWorkSpace,
                       TST_gWorkSpaceSizeInBytes); 
  
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"SST_Init","TLK_SCLK_TST_Init");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);


#endif


 #if (TLK_SCLK_VNVS_EXT_FILE || TLK_SCLK_VNVS_NVS)
 #ifndef DX_NVS_RAM
  TST_Error = DX_VOS_FileOpen(&TST_gMainDBFileHandle,
                           TLK_SCLK_ATP_FILE_NAME,
                           DX_FILE_OPEN_ALWAYS,
                           DX_SHARE_READ_WRITE);
  if(TST_Error != DX_SUCCESS)
  {
    DX_VOS_Printf("CANT OPEN FILE , error = %x", TST_Error);
    return TST_Error;
  }
  #else 
  	TST_gNVSFileHandle   = (DxVosFile)TST_MainSCLK_TLK_NVSPool;
  #endif
 #endif

 
  /*2. Initialize the new master clock descriptor using TLK_SCLK_Init. */
  TST_Error = TLK_SCLK_Init(TST_gWorkSpace,TST_gWorkSpaceSizeInBytes);

  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"TLK_SCLK_Init", "TLK_SCLK_TST_Init");

  if (TST_Error != TST_PASS)
    return TST_FAIL;

  return TST_PASS;
}

/*****************************************************************************
* Function Name:                                                           
*  TLK_SCLK_TST_TerminateSST        
* 
* Outputs:
*  DxError_t - Function error return                                        
*
* Description:                                                                 
* this function Terminate the secure clock and the SST 
*
******************************************************************************/
DxError_t TLK_SCLK_TST_Terminate(void)
{
  DxError_t TST_Error;

 
  

  TST_Error = TLK_SCLK_Terminate(TST_gWorkSpace,TST_gWorkSpaceSizeInBytes);
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"TLK_SCLK_Terminate","TLK_SCLK_TST_Terminate");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);

#if TLK_SCLK_VNVS_SST 
  TST_Error = SST_Terminate();
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"SST_Terminate","TLK_SCLK_TST_Terminate");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);

  #ifndef DX_NVS_RAM  
  TST_Error = DX_VOS_FClose(TST_gMainDBFileHandle);
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"DX_VOS_FClose - TST_gMainDBFileHandle","TLK_SCLK_TST_Terminate");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);

  TST_Error = DX_VOS_FClose(TST_gSecondaryDBFileHandle);
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"DX_VOS_FClose - TST_gSecondaryDBFileHandle","TLK_SCLK_TST_Terminate");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);
 #endif

#endif



#if (TLK_SCLK_VNVS_EXT_FILE || TLK_SCLK_VNVS_NVS)
  TST_Error = DX_VOS_FClose((DxVosFile)TST_gMainDBFileHandle);
  TST_Error = TLK_SCLK_TST_CheckErrorReturn(TST_Error,"DX_VOS_FClose - TST_gMainDBFileHandle ","TLK_SCLK_TST_Terminate");
  MW_ATP_RETURN_ON_FAILURE(TST_Error);
  
#endif
  return TST_PASS;

}

